#ifndef FREEHDL_KERNEL_ATTRIBUTES_H
#define FREEHDL_KERNEL_ATTRIBUTES_H

/* *************************************************************
 *  Function kind attributes for signals
 * ************************************************************* */

/* Event attribute for an scalar signal! Bote that sinf must point to
 * a scalar signal! */
inline int attr_scalar_EVENT(sig_info_base *sinfo)
{
  extern kernel_class kernel;
  return kernel.get_cycle_id() == sinfo->readers[0]->last_event_cycle_id;
}

/* Event attribute for a composite signal! */
int attr_composite_EVENT(sig_info_base *sinfo, acl *a);

/* Active attribute for an scalar signal! Bote that sinf must point to
 * a scalar signal! */
inline int attr_scalar_ACTIVE(sig_info_base *sinfo)
{
  extern kernel_class kernel;
  const reader_info &rinfo = *sinfo->readers[0];
  const int cycle_id = kernel.get_cycle_id();
  return (cycle_id == rinfo.last_event_cycle_id) || (cycle_id == rinfo.last_active_cycle_id);
}

/* Active attribute for a composite signal! */
int attr_composite_ACTIVE(sig_info_base *sinfo, acl *a);


#endif
