#ifndef FREEHDL_KERNEL_ERROR_H
#define FREEHDL_KERNEL_ERROR_H

// FreeHDL error handler interface.

#include <string>

#define ERROR_INTEGER_OVERFLOW 100
#define ERROR_FLOATING_POINT_OVERFLOW 101
#define ERROR_ENUM_OVERFLOW 102
#define ERROR_PHYSICAL_OVERFLOW 103
#define ERROR_ARRAY_INDEX 104
#define ERROR_INCOMPATIBLE_ARRAYS 105
#define ERROR_UNKNOWN_COMPONENT 106
#define ERROR_DUBLICATE_INSTANCE_NAME 107
#define ERROR_ARRAY_INDEX_OUT_OF_BOUNDS 108


//Event handler internal errors
#define ERROR_EVENT_GENERAL_ERROR 200

#define ERROR_NOT_SUPPORTED 1000


// Prints an error message on the screen and stops program execution
void error(int errnum, const string &str="");

// Prints string on the screen and stops program execution
void error(const string &str, const string &file, int line);

// Prints string on the screen
void debug(const string &str, const string &file, int line);


#ifdef DEBUG
void execute_assert(bool expr, string str, int line);
#define v_assert(a,b) execute_assert(a,b,__LINE__)
#else
#define v_assert(a,b)
#endif

#endif
