#ifndef FREEHDL_KERNEL_HANDLE_INFO_H
#define FREEHDL_KERNEL_HANDLE_INFO_H

#include <string>
#include <freehdl/kernel-handle.hh>
#include <freehdl/kernel-list.hh>

// For each data architecture a handle_info object is instantiated.
// It is used during elaboration to call the constructors of the 
// corresponding architecture class. Note, the architecture classes
// are unkown to the kernel at kernel compile time
struct handle_info {  
  string library; // Library the component belongs to
  string entity; // Entity name of the component
  string architecture; // Architecture name of the component
  // Pointer to the handle function which instantiates the corresponding
  // architecture
  handle function;
  handle_info() {};
  handle_info(const string &lib, const string &ent, const string &arch, handle func) {
    library = lib;
    entity = ent;
    architecture = arch;
    function = func;
  }
  bool match(const string &lib, const string &ent, const string &arch) {
    return (lib == "" || lib == library) &&
      (ent == "" || ent == entity) &&
      (arch == "" || arch == architecture);
  }
};


// This list collects all architecture classes which are present in
// hte current VHDL model
extern list<handle_info*> components; 


#endif
