#ifndef FREEHDL_KERNEL_HANDLE_H
#define FREEHDL_KERNEL_HANDLE_H

#include <freehdl/kernel-name-stack.hh>
#include <freehdl/kernel-map-list.hh>


// For each architecture a separate handle functions to instantiate
// the architecture is declared.
typedef void (*handle)(name_stack &, map_list *);

// This function is used to collect all handle-functions which are 
// present in the current model. It is used to initialize some dummy
// variables. Hence it is executed BEFORE main() start.
int
add_handle(const string &library, const string &entity, const string &architecture, handle func);

// Returns handle function pointer to the component which matches 'library',
// 'entity', and 'architecture'. An empty string "" is treated as wildcard.
handle
get_handle(const string &library, const string &entity, const string &architecture);


#endif
