#ifndef FREEHDL_KERNEL_PROCESS_BASE_H
#define FREEHDL_KERNEL_PROCESS_BASE_H

#include <string>
#include <freehdl/kernel-name-stack.hh>

struct process_base;

/******************************************************
 * Some definitions which are used by the kernel only 
 ******************************************************/
#ifdef KERNEL 

#include <string>
#include <map>

typedef map<string, process_base*, less<string> > process_map;

// signal_map is a hash table (map) to associate process names with
// the corresponding process_base pointer.
extern process_map process_table;

#endif
/******************************************************
 * End of inernal kernel definitions    
 ******************************************************/


// Each process is derived from this class
struct process_base {
  // next_process is used to build up a linked list of processes which
  // must be executed in the current simulation cycle. If
  // next_proccess is equal to NULL then the process is currently not
  // on the list. If it is equal to -1 then the process IS the last
  // element of the list. Otherwise next_process points to the next
  // process on the list.
  process_base *next_process;
  short jmp;
  // Id of the currently active wait statement. Each wait statement
  // is associated an unique id number.
  short active_wait_id;
  // timeout variable is true if a process is activated because
  // of a timeout condition 
  bool timeout_jmp; 
  // Instance name of the process
  string instance_name;
  // Constructor
  process_base(name_stack &in);
  // Activates a specific wait statement of the process. The wait
  // statement is identified by a id.
  void wait(short i) { active_wait_id = i; }
  // This method executes the process
  virtual bool execute() = 0;
};




#endif
