#ifndef FREEHDL_KERNEL_READER_INFO_H
#define FREEHDL_KERNEL_READER_INFO_H

#include <freehdl/kernel-wait-info.hh>
#include <freehdl/kernel-classes.hh>
#include <freehdl/kernel-list.hh>

// This class stores the processes which are sensitive
// on a reader of a signal
class reader_info {
public:
  // Points to the reader
  void *reader;
  // Array of wait_info instances
  array<wait_info> wait_elements;
  // Stores the transaction which caused the last event on the signal
  void *last_event_tr_item;
  // Cycle id of the simulation cycle in which the most recent event
  // on the signal appeared
  int last_event_cycle_id;
  // Points to an transaction element. The value stores the last value
  // before the signal changed to the current value (needed for the
  // last_value attribute). The time element of the transaction
  // contains the time stamp of the most recent assignment to the
  // signal which caused NO event.
  void *last_value_tr_item;
  // Cycle id of the last signal assignment which caused NO
  // transaction.
  int last_active_cycle_id;
  // Constructor
  reader_info(void *r, type_info_interface *type);
  // Activates all processes in wait_elements. This means the
  // processes will be eceuted during the current simulation cycle if
  // the corresponding wait_info element is active.
  void activate_processes();
};



#endif
