#ifndef FREEHDL_STD_STANDARD_H
#define FREEHDL_STD_STANDARD_H

#include <math.h>
#include <freehdl/std-vhdl-types.hh>



/* ***************************************************************
 * Predefined VHDL types
 * *************************************************************** */

/** Enum info class of predefined VHDL type BIT */
class L3std_Q8standard_I3bit : public enum_info_base {
  static const char *values[2]; //={"'0'", "'1'"};
public:
  L3std_Q8standard_I3bit() : enum_info_base(0, 1, values) {};
  static const char **get_values() { return values; }
  static int low() { return 0; }
  static int high() { return 1; }
  static int left() { return 0; }
  static int right() { return 1; }
};



extern L3std_Q8standard_I3bit *L3std_Q8standard_I3bit_INFO;
#define L3std_Q8standard_T3bit enum_type<L3std_Q8standard_I3bit>
typedef enumeration bit;




/** Enum info class of predefined VHDL type BOOLEAN */
class L3std_Q8standard_I7boolean : public enum_info_base {
  static const char *values[2]; //={"'0'", "'1'"};
public:
  L3std_Q8standard_I7boolean() : enum_info_base(0, 1, values) {};
  static const char **get_values() { return values; }
  static int low() { return 0; }
  static int high() { return 1; }
  static int left() { return 0; }
  static int right() { return 1; }
};


extern L3std_Q8standard_I7boolean *L3std_Q8standard_I7boolean_INFO;
#define L3std_Q8standard_T7boolean boolean_enum_type
typedef enumeration boolean;



/** Integer info class of predefined VHDL INTEGER type */
class L3std_Q8standard_I7integer : public integer_info_base {
public:
  static int low() { return INT_MIN+1; };
  static int high() { return INT_MAX; }
  static int left() { return INT_MIN+1; }
  static int right() { return INT_MAX; }
  L3std_Q8standard_I7integer() : 
    integer_info_base(left(), right(), low(), high()) {};
};


extern L3std_Q8standard_I7integer *L3std_Q8standard_I7integer_INFO;


/** Integer info class of predefined VHDL NATURAL type */
class L3std_Q8standard_I7natural : public integer_info_base {
public:
  static int low() { return 0; };
  static int high() { return INT_MAX; }
  static int left() { return 0; }
  static int right() { return INT_MAX; }
  L3std_Q8standard_I7natural() : 
    integer_info_base(left(), right(), low(), high()) {};
};

extern L3std_Q8standard_I7natural *L3std_Q8standard_I7natural_INFO;
typedef integer natural;


/** Integer info class of predefined VHDL POSITIVE type */
class L3std_Q8standard_I8positive : public integer_info_base {
public:
  static int low() { return 1; };
  static int high() { return INT_MAX; }
  static int left() { return 1; }
  static int right() { return INT_MAX; }
  L3std_Q8standard_I8positive() : 
    integer_info_base(left(), right(), low(), high()) {};
};

extern L3std_Q8standard_I8positive *L3std_Q8standard_I8positive_INFO;
typedef integer positive;


/** Floatig point info class of predefined VHDL REAL type */
class L3std_Q8standard_I4real : public float_info_base {
public:
  static double low() { return DBL_MIN; };
  static double high() { return DBL_MAX; }
  static double left() { return DBL_MIN; }
  static double right() { return DBL_MAX; }
  L3std_Q8standard_I4real() : 
    float_info_base(left(), right(), low(), high()) {};
};

extern L3std_Q8standard_I4real *L3std_Q8standard_I4real_INFO;
typedef floatingpoint real;


/** Physical point info class of predefined VHDL TIME type */
class L3std_Q8standard_I4time : public physical_info_base {
public:
  const static long unit_count = 7;
  const static char *units[7];
  const static long long scale[7];
  static long long low() { return LONG_MIN; };
  static long long high() { return LONG_MAX; }
  static long long left() { return LONG_MIN; }
  static long long right() { return LONG_MAX; }
  L3std_Q8standard_I4time() : 
    physical_info_base(left(), right(), low(), high(), units, scale, unit_count) {};
};


extern L3std_Q8standard_I4time *L3std_Q8standard_I4time_INFO;
#define L3std_Q8standard_T4time physical_type<L3std_Q8standard_I4time>
// Just to save some typing
typedef lint time;



/** Predefined array type bit_vector */
extern array_info *L3std_Q8standard_I10bit_vector_INFO;
#define L3std_Q8standard_T10bit_vector array_type<bit,L3std_Q8standard_I7natural>
// Just to save some typing
typedef L3std_Q8standard_T10bit_vector bit_vector;

#endif
