#include <freehdl/kernel-acl.hh>
#include <freehdl/std-vhdl-types.hh>


acl *free_acl[MAX_ACL_DEPTH + 1]; // List of acl objects that are currently not in use

pacl tmpacl = new(100) acl; // temporary acl instance with 100 elements (should be enough
			    // for most cases!
pacl tmpacl2 = new(100) acl; // temporary acl instance with 100 elements (should be enough
                             // for most cases!

bool 
acl::operator==(const acl &a) {
  if (this == NULL)
    return a.end();
  int i = 0;
  while (!end() && !a.end()) {
    if (get(i) != ACL_RANGE) {
      if (get(i) != a.get(i)) return false;
      i++;
    } else {
      if (a.get(i) != ACL_RANGE) return false;
      int low1 = get(i+2) == to? get(i+1) : get(i+3);
      int high1 = get(i+2) == to? get(i+3) : get(i+1);
      int low2 = a.get(i+2) == to? a.get(i+1) : a.get(i+3);
      int high2 = a.get(i+2) == to? a.get(i+3) : a.get(i+1);
      if (low1 != low2 || high1 != high2) return false;
      i += 3;
    }
  }
  return true;
}
