#include <iostream.h>
#include <freehdl/kernel-error.hh>


void error(int errnum, const string &str) {
  cout << "Runtime error " << errnum << "." << endl;
  if (str!="") {
    cout << str << endl;
  }
  exit (1);
}

void error(const string &str, const string &file, int line) {
  cout << "Error in file " << file << " at line " << line << ": " << str << endl;
  exit(1);
}

void debug(const string &str, const string &file, int line) {
  cout << "Debug info from " << file << " at line " << line << ": " << str << endl;
}

#ifdef DEBUG
void execute_assert(bool expr, string str, int line) {
  if (expr) 
    error(str, "Unknown", line); 
}
#endif


