#include <freehdl/kernel-flags.hh>
#include <freehdl/kernel-handle.hh>
#include <freehdl/kernel-handle-info.hh>


// List of component types currently present in the model
list<handle_info*> components; 


int
add_handle(const string &library, const string &entity, const string &architecture, handle func) {
  handle_info *new_handle = new handle_info(library, entity, architecture, func);
  components.insert(components.first(), new_handle); // Add handle to list
  
  REPORT(cout << "Component " << library << ":" << entity << ":" << architecture <<
	 " added to component list." << endl;)
}


// Returns handle function pointer to the component wich matches 'library',
// 'entity', and 'architecture'. An empty string "" is treated as wildcard.
handle
get_handle(const string &library, const string &entity, const string &architecture)
{
  void *pos = components.first();
  while (pos) {
    if (components.content(pos)->match(library, entity, architecture)) 
      return components.content(pos)->function;
    pos = components.next(pos);
  }
  return NULL;
}
