#include <freehdl/kernel-map-list.hh>
#include <freehdl/kernel-error.hh>
#include <freehdl/kernel-sig-info.hh>

// global temproary map list object 
map_list tmpml;


signal_link::signal_link()
{
  formal_aclp = NULL;
  formal_name = "";
  wrapper_fn_formal = NULL;
  actual_aclp = NULL;
  actual_signal = NULL;
  value = NULL;
  type = NULL;
  wrapper_fn_actual = NULL;
}

signal_link::~signal_link()
{
  if (formal_aclp) delete formal_aclp;
  if (actual_aclp) delete actual_aclp;
}

generic_link::generic_link()
{
  formal_aclp = NULL;
  formal_name = "";
  value = NULL;
  type = NULL;
}

generic_link::~generic_link()
{
  if (formal_aclp) delete formal_aclp;
}

map_list::map_list()
{
}

map_list::~map_list()
{
  void *pos = generic_maplist.first();
  while (pos) { 
    delete generic_maplist.content(pos); 
    pos = generic_maplist.next(pos);
  }

  pos = signal_maplist.first();
  while (pos) { 
    delete signal_maplist.content(pos);
    pos = signal_maplist.next(pos);
  }
}

// The generic map with expression
void map_list::generic_map(const char *formal, acl *formal_acl
, void * value, type_info_interface *type)
{
  generic_link *glink = new generic_link;

  glink->formal_name = string(formal);
  glink->formal_aclp = formal_acl->clone();
  glink->value = value;
  glink->type = type;

  generic_maplist.append(glink);
}

// The generic map with open
void map_list::generic_map(const char *formal, acl *formal_acl)
{
  generic_link *glink = new generic_link;

  glink->formal_name = string(formal);
  glink->formal_aclp = formal_acl->clone();
  glink->value = NULL;
  glink->type = NULL;

  generic_maplist.append(glink);
}

// Adds a signal link to the signal_map list
void map_list::signal_map(const char *formal, acl *formal_acl
, sig_info_base *actual, acl *actual_acl)
{
  signal_link *slink = new signal_link;

  slink->formal_name = string(formal);
  slink->formal_aclp = formal_acl->clone();
  slink->actual_signal = actual;
  slink->actual_aclp = actual_acl->clone();

  signal_maplist.append(slink);
}


// the mapping with an expression
void map_list::signal_map(const char *formal, acl *formal_acl
, void *value, type_info_interface *type)
{
  signal_link *slink = new signal_link;

  slink->formal_name = string(formal);
  slink->formal_aclp = formal_acl->clone();
  slink->value = value;
  slink->type = type;

  signal_maplist.append(slink);
}


// the mapping with open
void map_list::signal_map(const char *formal, acl *formal_acl)
{
  signal_link *slink = new signal_link;

  slink->formal_name = string(formal);
  slink->formal_aclp = formal_acl->clone();

  signal_maplist.append(slink);
}

// the mapping with formal convert function
void map_list::signal_map(const char *formal, acl *formal_acl
, void (*wrapper_fn_formal)(void *,void *)
, sig_info_base *actual, acl *actual_acl)
{
  signal_link *slink = new signal_link;

  slink->formal_name = string(formal);
  slink->formal_aclp = formal_acl->clone();
  slink->wrapper_fn_formal = wrapper_fn_formal;
  slink->actual_signal = actual;
  slink->actual_aclp = actual_acl->clone();

  signal_maplist.append(slink);
}

// the mapping with actual convert function
void map_list::signal_map(const char *formal, acl *formal_acl
, sig_info_base *actual, acl *actual_acl
,void (*wrapper_fn_actual)(void *,void *))
{
  signal_link *slink = new signal_link;

  slink->formal_name = string(formal);
  slink->formal_aclp = formal_acl->clone();
  slink->actual_signal = actual;
  slink->actual_aclp = actual_acl->clone();
  slink->wrapper_fn_actual = wrapper_fn_actual;

  signal_maplist.append(slink);
}

// the mapping with formal/actual convert function
void map_list::signal_map(const char *formal, acl *formal_acl
, void (*wrapper_fn_formal)(void *,void *)
, sig_info_base *actual, acl *actual_acl
,void (*wrapper_fn_actual)(void *,void *))
{
  signal_link *slink = new signal_link;

  slink->formal_name = string(formal);
  slink->formal_aclp = formal_acl->clone();
  slink->wrapper_fn_formal = wrapper_fn_formal;
  slink->actual_signal = actual;
  slink->actual_aclp = actual_acl->clone();
  slink->wrapper_fn_actual = wrapper_fn_actual;

  signal_maplist.append(slink);
}

bool map_list::query_generic(list<generic_link*> &result, const string &name)
{
  void *tmp;
  generic_link *glink;
  
  tmp = generic_maplist.first();
  while ( tmp != NULL ) {
    glink = generic_maplist.content(tmp);
    if ( glink->formal_name == name ) {
      result.append(glink);
    }
    tmp = generic_maplist.next(tmp);
  }
  if ( result.size() )
    return true;
  else
    return false;
}

bool map_list::query_signal(list<signal_link*> &result, const string &name)
{
  void *tmp;
  signal_link *slink;
  
  tmp = signal_maplist.first();
  while ( tmp != NULL ) {
    slink = signal_maplist.content(tmp);
    if ( slink->formal_name == name ) {
      result.append(slink);
    }
    tmp = signal_maplist.next(tmp);
  }
  if ( result.size() )
    return true;
  else
    return false;
}



int 
map_list::get_port_array_bounds(list<signal_link*> &mlist, const string &name, 
				array_info *ainfo, int &left, int &right)
{
  int error_num = 0;

  /* Get absolute index bounds (determined from the array index type) */
  int length = -1, min_index = INT_MAX, max_index = INT_MIN;
  ainfo->index_type->get_bounds(left, right);

    /* Now analyze each value */
  void *pos = mlist.first();
  while (pos) {
    signal_link* slink = mlist.content(pos); /* Get map info instance */

    if (slink->formal_aclp->end()) {
      /* The actual is mapped to the entire formal */
      if (!slink->actual_aclp->end()) { 
	/* Mapping a part of an actual to a formal is not supported yet */
	error(ERROR_NOT_SUPPORTED, 
	      "Sorry, aapping a part of an actual to a formal is not supported yet");

      } else {
	/* The entire actual object is mapped to a entire formal. Next get
	 * the length of the actual array to calculate the left and right bounds 
	 * of the formal. */
	length = ((array_info*)slink->actual_signal->type)->length;
	int new_right = left + (right >= left? 1 : -1) * (length - 1);
	/* Check whether new right value is not out of bounds and only a single
	 * mapping statement is associated with this formal. */
	if (!check_bounds(left, right, new_right) ||
	    mlist.size() > 1) {
	  error_num = -1;
	  error(ERROR_ARRAY_INDEX);
	} else
	  right = new_right; /* Set the new right value */
	return error_num;
      }

    } else {
      /* Only a part of the formal is mapped to the actual */
      /* Check whether the entire formal actually has been already mapped. If yes, then
       * report an error and die! */
      if (length != -1)
	error(ERROR_ARRAY_INDEX);
      min_index = min(min_index, slink->formal_aclp->get());
      max_index = max(max_index, slink->formal_aclp->get());
    }

    pos = mlist.next(pos);
  }

  /* Each mapping expressions for this formal has been visited. Now calculate final
   * bounds or return an error. */
  if (!check_bounds(left, right, min_index) ||
      !check_bounds(left, right, max_index)) {
    error_num = -1;
    error(ERROR_ARRAY_INDEX);
    return error_num;
  }
  left = (left <= right)? min_index : max_index;
  right = (left <= right)? max_index : min_index;
  return 0;
}


void map_list::reset()
{
  signal_maplist.reset();
  generic_maplist.reset();
}
