#define KERNEL

#include <freehdl/kernel-name-stack.hh>
#include <freehdl/kernel-process-base.hh>
#include <freehdl/kernel-kernel-class.hh>

// signal_map is a hash table (map) to associate process names with
// the corresponding process_base pointer.
process_map process_table;


process_base::process_base(name_stack &in) {
  jmp = 0;
  next_process = NULL; // The process is not on the execution list
  instance_name = in.get_name();
  timeout_jmp = 0;
  process_map::iterator it = process_table.begin();
  if (process_table.find(instance_name) != process_table.end())
    error(ERROR_DUBLICATE_INSTANCE_NAME, string("Dublicate instance name '") + 
  	  instance_name + string("'"));
  process_table[instance_name] = this; // Store new process into global hash table
}


