#include <freehdl/kernel-wait-info.hh>
#include <freehdl/kernel-reader-info.hh>
#include <freehdl/kernel-kernel-class.hh>


reader_info::reader_info(void *r, type_info_interface *type) 
{
  reader = r;
  // Get transaction item to hold the current event transaction and
  // initialize its value
  last_event_tr_item = fqueue<long long int, time>::get_new_item();
  type->fast_copy(&fqueue<long long int, time>::content(last_event_tr_item), reader);
  fqueue<long long int, time>::key(last_event_tr_item) = time(0x7000000000000000LL);
  // Set value to -1 to show that up to now no event occured on this reader
  last_event_cycle_id = -1; 
  // Get transaction item to hold the last value
  last_value_tr_item = fqueue<long long int, time>::get_new_item();
  type->fast_copy(&fqueue<long long int, time>::content(last_value_tr_item), reader);
  fqueue<long long int, time>::key(last_value_tr_item) = time(0x7000000000000000LL);
  // Set value to -1 to show that up to now no transaction has been
  // assigned to this reader
  last_active_cycle_id = -1;
}


void
reader_info::activate_processes()
{
  for (int i = 0; i < wait_elements.size(); i++) {
    wait_info &winfo = wait_elements.content(i);
    if (winfo.process->active_wait_id == winfo.wait_id)
      kernel.add_process_to_execute(winfo.process);
  }
}
