; -*- scheme -*-

(include "freehdl/vaul-chunk.t")

(define (format-v2cc-kind name)
  (upcase (concat-strings (cons "v2cc" (cdr (syllables name))) "_")))

(chunk v2cc
       (struct-fmt "~a")
       (pointer-fmt "p~a")
       (kind-fmt-func format-v2cc-kind)
       )

(header-add "#include <freehdl/vaul-chunk.h>")
(header-add "#include <string>")
(header-add "#include <set>")
(header-add "#include <list>")
(header-add "#include <vector>")
(header-add "#include <map>")
(header-add "#include <deque>")
(header-add "#include <vector>")
(header-add "#include <algorithm>")
(header-add "#include \"v2cc.h\"")
;; Returns kind of a VHDL operator:
;;  NO_OP if the function does not denote an operator
;;  STD_OP if the funcion denotes an predefined VHDL operator
;;  BASIC_OP if the function denotes an operator defined in an 
;;           IEEE library (e.g. numeric_std)
;;  USER_OP an user defined operator
(header-add "enum op_type { NO_OP, STD_OP, BASIC_OP, USER_OP };")
;;  
(impl-add "#include \"v2cc-chunk.h\"")

;;(defctype int)
(defctype set_string (cname "set<string>"))
(defctype list_string (cname "list<string>"))
(defctype list_string_ref (cname "list<string>&"))
(defctype vector_string (cname "vector<string>"))
(defctype vector_string_ref (cname "vector<string>&"))
(defctype vector_bool (cname "vector<bool>"))
(defctype vector_lint_ref (cname "vector<long long int>&"))
(defctype RegionStack (cname "RegionStack"))
(defctype RegionStack_ref (cname "RegionStack &"))
(defctype ContextInfo (cname "ContextInfo"))
(defctype ContextInfo_ref (cname "ContextInfo &"))
(defctype pContextInfo (cname "ContextInfo*"))
(defctype pAccessDescriptor (cname "pAccessDescriptor"))
(defctype pIIR_Root (cname "pIIR_Root"))
(defctype pIIR_Expression (cname "pIIR_Expression"))
(defctype lint (cname "long long int"))
(defctype scalar_data (cname "scalar_data"))
(defctype string (cname "string"))
(defctype string_ref (cname "string&"))
(defctype set_IIR_SimpleReference (name "set<IIR_SimpleReference>"))
(defctype pIIR_ObjectDeclaration (cname "pIIR_ObjectDeclaration"))
(defctype RangeDescriptor_vec (cname "vector<RangeDescriptor>"))
(defctype id_type)
;;(defctype static_level_type)
(defctype op_type)

(defgeneric emit_def 
  (args (string_ref str) (RegionStack_ref ctxt))
  (methods
   IIR_Subtype IIR_IntegerType IIR_PhysicalType
   IIR_FloatingType IIR_EnumerationType
   IIR_ArrayType IIR_RecordType IIR_FileType IIR_Type))

(defgeneric emit_decl
  (args (string_ref str) (RegionStack_ref ctxt) (int l))
  (methods
   IIR_Declaration IIR_SubprogramDeclaration IIR_VariableDeclaration
   IIR_ConstantDeclaration IIR_FileDeclaration IIR_SignalDeclaration
   IIR_TypeDeclaration IIR_PackageDeclaration IIR_PackageBodyDeclaration
   IIR_EntityDeclaration IIR_ArchitectureDeclaration
   IIR_ConfigurationDeclaration IIR_ComponentDeclaration))

;;(defgeneric emit_stat
;;  (args (int l))
;;  (methods
;;   IIR_NullStatement IIR_ReturnStatement IIR_VariableAssignmentStatement
;;  IIR_IfStatement IIR_CaseStatement IIR_LoopStatement IIR_LoopControlStatement
;;   IIR_ProcedureCallStatement IIR_WaitStatement IIR_AssertionStatement
;;   IIR_ReportStatement IIR_SignalAssignmentStatement
;;   IIR_SequentialStatement))

(defgeneric emit_expr
  (args (string_ref str) (RegionStack_ref ctxt) (id_type t))
  (return bool)
  (methods
   IIR_FunctionCall IIR_SimpleReference IIR_AbstractLiteralExpression
   IIR_TypeConversion IIR_QualifiedExpression IIR_EnumLiteralReference
   IIR_ArrayReference IIR_ArrayLiteralExpression IIR_RecordReference
   IIR_RecordAggregate IIR_ArrayAggregate IIR_SliceReference
   IIR_AccessReference IIR_AttrSignalRef IIR_AttrSigFunc IIR_ArrayAttr
   IIR_Expression IIR_EnumerationLiteral))

;;
;;  emit class headers (AKA declarations)
;;

(defgeneric emit_hdr
  (args (string_ref str) (RegionStack_ref ctxt) (int l))
  (methods
   IIR_EntityDeclaration 
   IIR_ArchitectureDeclaration
   IIR_ProcessStatement
   IIR_ComponentInstantiationStatement
   IIR_BlockStatement
   IIR_ConcurrentGenerateStatement
   IIR_ConcurrentStatement
   IIR_ConcurrentStatementList
   IIR_SubprogramDeclaration
   IIR_EnumerationType
   IIR_ScalarSubtype
   IIR_ArrayType
   IIR_ArraySubtype
   ))

;;
;;  emit class implementation (AKA definition)
;;

(defgeneric emit_impl
  (args (string_ref str) (RegionStack_ref ctxt) (int l))
  (methods
   IIR_NullStatement IIR_ReturnStatement IIR_VariableAssignmentStatement
   IIR_IfStatement IIR_CaseStatement IIR_LoopStatement IIR_LoopControlStatement
   IIR_ProcedureCallStatement IIR_WaitStatement IIR_AssertionStatement
   IIR_ReportStatement IIR_SignalAssignmentStatement
   IIR_SequentialStatement 
   IIR_EntityDeclaration 
   IIR_ArchitectureDeclaration
   IIR_ProcessStatement
   IIR_ComponentInstantiationStatement
   IIR_BlockStatement
   IIR_ConcurrentGenerateStatement
   IIR_SequentialStatementList
   IIR_SequentialStatement
   IIR_ConcurrentStatement
   IIR_ConcurrentStatementList
   IIR_SubprogramDeclaration
   IIR_EnumerationType
   IIR_ScalarSubtype
   IIR_ArrayType
   IIR_ArraySubtype
   ))


;; ******************************************************************************************
;; Name: m_emit_info_init , generic function
;;
;; Description: emits initialization code of type info instances
;; 
;; Return value: Static level of the array info instance
;;
;; ******************************************************************************************
(defgeneric emit_info_init
  (args (string_ref str) (RegionStack_ref ctxt) (int l))
  (return IR_StaticLevel)
  (methods
   IIR_EnumerationType
   IIR_ArrayType
   IIR_ArraySubtype
   ))


(defgeneric emit 
  (args (string_ref str) (RegionStack_ref ctxt) (int l))
  (methods
   IIR_Declaration IIR_Type IIR_InterfaceDeclaration 
   IIR_TypeList))


(defgeneric get_acl 
  (args (list_string_ref alist) (RegionStack_ref ctxt) (IR_StaticLevel slevel) (id_type t) (bool start))
  (return bool)
  (methods
   IIR_Expression IIR_SimpleReference IIR_ArrayReference
   IIR_ExplicitRange IIR_SliceReference))

;; ******************************************************************************************
;; Name: m_explore_and_check, generic function
;;
;; Description: explore (collect informations about node) and check
;; node for correctness
;;
;; Return value: returns number of errors found
;;
;; ******************************************************************************************
(defgeneric explore_and_check
  (args (RegionStack_ref rstack))
  (return int)
  (methods
   IIR_EntityDeclaration
   IIR_DeclarationList
   IIR_ArchitectureDeclaration
   IIR_ConcurrentStatementList
   IIR_ProcessStatement
   IIR_PackageDeclaration
   IIR_PackageBodyDeclaration
   IIR_ConfigurationDeclaration
   IIR_ComponentDeclaration
   IIR_SequentialStatementList
   IIR_IfStatement
   IIR_ForLoopStatement
   IIR_WhileLoopStatement
   IIR_LoopStatement
   IIR_CaseStatement
   IIR_WaitStatement
   IIR_SignalAssignmentStatement
   IIR_VariableAssignmentStatement
   IIR_ComponentInstantiationStatement
   IIR_ProcedureCallStatement
   IIR_EnumerationType
   IIR_Type
   IIR_NullStatement
   ))


;; ******************************************************************************************
;; Name: m_get_context, generic function
;;
;; Description: Analyzes statements and collects all abjects which are
;; accessed. The information about the accessed objects are stored in
;; a ContextInfo instance. A ContextInfo instance stores three
;; different kinds of informations: 
;;
;; 1. accessed_objects = all objects
;; which are accessed (read, written, sensitive).
;;
;; 2. wait_statements = pointer to the wait statements included in the
;; current context
;;
;; 3. signal_assignment_statements = list of pointers to all signal
;; assignment statements included in the current context
;;
;; 4. internal_vars = internal objects required by the generated code
;;
;; Parameter: ctxt = context info instance
;;   target = is true if the expression is target of an assignment
;;   level = level the object is located at. The entire statement
;; is assigned level 0. The level is increased each time an object is
;; included in an argument to a subroutine or an index value of an
;; array reference.
;; 
;; Return value: returns a pointer to the corresponding access
;; descriptor if an expression is analyzed. Otherwise, NULL is
;; returned.
;;
;; ******************************************************************************************
(defgeneric get_context
  (args (ContextInfo_ref ctxt) (RegionStack_ref rstack) (bool target) (int level))
  (return pAccessDescriptor)
  (methods
   IIR_FunctionCall
   IIR_SimpleReference
   IIR_ArrayReference
   IIR_ArrayRange
   IIR_ExplicitRange
   IIR_OthersIndexedAssociation
   IIR_RangeIndexedAssociation
   IIR_SingleIndexedAssociation
   IIR_SliceReference
   IIR_RecordReference
   IIR_Expression
   IIR_ExpressionList
   IIR_ArrayAggregate
   IIR_WaitStatement
   IIR_AttrSigFunc
   ))


;; ******************************************************************************************
;; Name: m_check_expression , generic function
;;
;; Description: checks whether expression is valid and contains no
;; errors. Any errors found are reportet. Parameter rstack is a
;; reference to the current regions stack
;; 
;; Return value: returns number of errors which were found in the expression
;;
;; ******************************************************************************************
(defgeneric check_expression
  (args (RegionStack_ref rstack))
  (return int)
  (methods
   IIR_FunctionCall
   IIR_SimpleReference
   IIR_ArrayReference
   IIR_ArrayRange
   IIR_ExplicitRange
   IIR_OthersIndexedAssociation
   IIR_RangeIndexedAssociation
   IIR_SingleIndexedAssociation
   IIR_SliceReference
   IIR_RecordReference
   IIR_Expression
   IIR_ExpressionList
   IIR_ArrayAggregate
   IIR_AttrSigFunc
   ))


;; Returns kind of operator:
;;  NO_OP if the function does not denote an operator
;;  PREDEF_OP if the funcion denotes an predefined VHDL operator
;;  BASIC_OP if the function denotes an operator defined in an 
;;           IEEE library (e.g. numeric_std)
;;  OP else
(defgeneric get_operator_type
  (return op_type)
  (methods 
   IIR_FunctionDeclaration))


;; Returns the name of the corresponding c++ object which represents
;; the VHDL object in the generated code
(defgeneric get_access_string
  (return string_ref)
  (methods IIR_FunctionDeclaration))


;; stores the access name of an object. The access name represents the
;; corresponding object in the generated code.
(defextension IIR_Declaration
  ((string access)))


;; stores which kinds of optimization has been applied on node
(defextension IIR_Root
   ((int optimized (= "0"))))

;; Some additional information about expressions and some lterals nodes
(defextension IIR_Expression
  (
   (scalar_data folded_value) ;; Stores long long int/double value of a plain contant
   (bool valid_folded_value (= "false")) ;; folded_value contains an valid value
   ))

(defextension IIR_Literal
  (
   (scalar_data folded_value) ;; Stores long long int/double value of a plain contant
   (bool valid_folded_value (= "false")) ;; folded_value contains an valid value
   ))

(defextension IIR_EnumerationLiteral
  (
   (scalar_data folded_value) ;; Stores long long int/double value of a plain contant
   (bool valid_folded_value (= "false")) ;; folded_value contains an valid value
   ))


;; stores the index number of the corresponding wait_info object which 
;; connected with the wait statement
(defextension IIR_WaitStatement
  ((int wait_info_index)))


;; Stores context information about the declaration region
(defextension IIR_DeclarativeRegion
  ((ContextInfo context)))

;; Store some additional information about the array aggregat
(defextension IIR_ArrayAggregate
  ((int dest_length) ;; length of the aggregate as determined form the aggregate subtype
   (int dest_left) ;; left bound of aggregate as determined from the agregate subtype
   (int dest_right) ;; right bound of aggregate as determined from the agregate subtype
   (IR_Direction dest_direction) ;; direction of aggregate as determined from the agregate subtype
   (bool named_association) ;; is true when the aggregate uses named association
   (bool known_subtype) ;; is true if subtype of aggregate is known from the context
   (bool has_others) ;; aggregat includes an others choice
   (bool locally_static_ranges) ;; true if all index ranges of the choices are locally static
   (int total_length) ;; total number of array elements (can be determined only if locally_static_ranges=true)
   (int min_index) ;; minimal index number among all choices (if determinable, i.e. locally_static_ranges=true)
   (int max_index))) ;; maximal index number among all choices (if determinable, i.e. locally_static_ranges=true)


;; Some additional information about a specific indexed association
(defextension IIR_IndexedAssociation
  ((bool locally_static_range) ;; true if all choices are locally range
   (int length) ;; number of elements (can be determined only if locally_static_range=true)
   (int min_index) ;; minimal index number among all choices (if determinable, i.e. locally_static_range=true)
   (int max_index))) ;; maximal index number among all choices (if determinable, i.e. locally_static_range=true)

(defextension IIR_EnumerationType
  ((int enum_item_number))) ;; number of enumeration items


;; ******************************************************************************************
;; Name: m_get_object_declaration , generic function
;;
;; Description: Returns the object declaration a reference expression
;; is based on. E.g. an expression "sig(3 downto 1)" will retrun the
;; object delcration pointer associated with "sig". Note that if the
;; prefix is a signal kind attribute then this signal attribute object
;; is returned!
;; 
;; Return value: returns object declaration
;;
;; ******************************************************************************************

(defgeneric get_object_declaration
  (return pIIR_ObjectDeclaration)
  (methods
   IIR_ObjectReference
   IIR_SimpleReference
   IIR_SliceReference
   IIR_AttrSignalRef
   IIR_ArrayReference
   IIR_RecordReference
   ))



;; ******************************************************************************************
;; Name: V2CC_InternalObjectDeclaration, node
;;
;; Description: A new declaration node type for internal objects which
;; are created by the code generator. Nothe that internal objects are
;; introduced by the code generation phase. They are needed by the
;; generated code in order to successfully map VHDL code to C++.
;;
;; 
;;
;; ******************************************************************************************

(defnode V2CC_InternalObjectDeclaration (IIR_ObjectDeclaration)
  (
   ;; C++ type of the object plotted into a string. Note that if this
   ;; string is empty then the type of the object is defined by the
   ;; subtype slot of the inherited IIR_ObjectDeclaration class.
   (string cpp_type_string) 
   ;; Initial value of the object. If the string is empty then the
   ;; initial value may be specified by he corresponding expression
   ;; pointer of the base class.
   (string cpp_initial_string)
   ;; Some additional information may be stored here
   (int flags))
  )


;; ******************************************************************************************
;; Name: V2CC_InternalCode, node
;;
;; Description: Stores generated C++ code sequences which shall be
;; printed to the output file. Usually, it is used to store code
;; generated from VHDL subprograms declarations.
;; 
;;
;; ******************************************************************************************

(defnode V2CC_InternalCode (IIR_ObjectDeclaration)
  (
   ;; Header code
   (string cpp_header_string) 
   ;; Implementation code
   (string cpp_impl_string)
   ;; Some additional information may be stored here
   (int flags))
  )


;; ******************************************************************************************
;; Name: m_get_discrete_range , generic function
;;
;; Description: Returns an array of RangeDescriptors derived from the
;; first parameter. Note that usually this function is called to
;; determine the bounds on an scalar type or the index bounds on an
;; array. In most cases it will return an array containing only a
;; single element. However, when called to extract the index ranges
;; from an array several RangeDescriptors may be returned where each
;; one covers one index range.
;; 
;; Return value: RangeDescriptor (see v2cc.h)
;;
;; ******************************************************************************************
(defgeneric get_discrete_range
  (args (RegionStack_ref rstack) (IR_StaticLevel slevel))
  (return RangeDescriptor_vec)
  (methods
   IIR_EnumerationType
   IIR_IntegerType
   IIR_PhysicalType
   IIR_ScalarSubtype
   IIR_ExplicitRange
   IIR_ArrayType
   IIR_ArraySubtype
   ))


;; ******************************************************************************************
;; Name: m_constant_fold , generic function
;;
;; Description: performs constant folding optimizations on nodes
;; 
;; Return value: returns number of errors found during folding
;;
;; ******************************************************************************************

(defgeneric constant_fold
  (args (RegionStack_ref rstack))
  (return int)
  (methods
   IIR_EntityDeclaration
   IIR_DeclarationList
   IIR_Type
   IIR_EnumerationType
   IIR_ArchitectureDeclaration
   IIR_ConcurrentStatementList
   IIR_ProcessStatement
   IIR_PackageDeclaration
   IIR_PackageBodyDeclaration
   IIR_ConfigurationDeclaration
   IIR_ComponentDeclaration
   IIR_SequentialStatementList
   IIR_CaseStatement
   IIR_IfStatement
   IIR_ForLoopStatement
   IIR_WaitStatement
   IIR_SignalAssignmentStatement
   IIR_VariableAssignmentStatement
   IIR_ComponentInstantiationStatement
   IIR_ProcedureCallStatement
   IIR_AttrSigFunc
   IIR_ArrayLiteralExpression
   IIR_EnumLiteralReference
   IIR_FunctionCall
   IIR_SimpleReference
   IIR_ArrayReference
   IIR_ArrayRange
   IIR_ExplicitRange
   IIR_OthersIndexedAssociation
   IIR_SingleIndexedAssociation
   IIR_RangeIndexedAssociation
   IIR_SliceIndexedAssociation
   IIR_SliceReference
   IIR_RecordReference
   IIR_Expression
   IIR_ExpressionList
   IIR_ArrayAggregate
   IIR_FloatingPointLiteral
   IIR_IntegerLiteral
   IIR_AbstractLiteralExpression
   IIR_EnumerationLiteral
   ))


