-----------------------------------------------------------
-- Example VHDL file
-----------------------------------------------------------

-- A simple 8 bit adder
entity adder is 
 	-- Currently, no generics are supported
	port (a, b : in bit_vector(0 to 7);
	      q : out bit_vector(0 to 7));
end adder;

architecture arch of adder is
begin
 p: process (a,b)
	variable ov : bit;
 begin
	ov := '0';
	for i in 7 downto 0 loop
		q(i) <= a(i) xor b(i) xor ov;
		if (a(i) = '1' and b(i) = '1') or
		   (ov = '1' and b(i) = '1') or
		   (a(i) = '1' and ov = '1') then
		 	ov := '1';
		else
			ov := '0';
		end if;
	end loop;
 end process;
end arch;

-- testbench to test the adder 
entity model is 
end model;

use WORK.adder;
-- This is a comment
architecture struct of model is
	signal asig, bsig, qsig : bit_vector(0 to 7) := (3 | 4 | 6 => '1', others => '0');
	signal clk : bit := '0';
begin

 -- Instantiate the adder circuit
 addcomp: entity adder
	port map(a => asig, b => bsig, q => qsig);
 
 clk <= not clk after 10 ns;

 process
 begin	
	-- Generate some test vectors for the
	-- adder
	asig <= (not asig(7)) & asig(0 to 6);
	bsig <= asig(1 to 7) & (not bsig(1));
	wait until clk = '1';
 end process;

end struct;

