/* implementation of vaul_design_file

   Copyright (C) 1994-1997 University of Dortmund
   Department of Electrical Engineering, AG SIV

   VAUL is free software; you can redistribute it and/or modify it
   under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   VAUL is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General
   Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with VAUL; see the file COPYING.LIB.  If not, write
   to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02111-1307 USA.


*/

#include <freehdl/vaul-dfile.h>

vaul_design_file::vaul_design_file (char *fn, FILE *f, int parser_flags)
  : lexer(fn, f),
    parser(&lexer)
{
  set_error (lexer);
  parser.flags = parser_flags;
}

vaul_design_file::~vaul_design_file()
{
}

vaul_design_unit *
vaul_design_file::read_design_unit (vaul_pool *p,
				    vaul_consumer *consumer)
{
  parser.consumer = consumer;
  if (consumer)
    consumer->parser = &parser;
  return parser.parse (p);
}
