/* beefed up printf

   Copyright (C) 1994-1997 University of Dortmund
   Department of Electrical Engineering, AG SIV

   VAUL is free software; you can redistribute it and/or modify it
   under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   VAUL is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General
   Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with VAUL; see the file COPYING.LIB.  If not, write
   to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02111-1307 USA.


*/

#include <freehdl/vaul-printer.h>
#include <string.h>

void vaul_printer::printf(const char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vfprintf(stdout, fmt, ap);
    va_end(ap);
}

void vaul_printer::fprintf(FILE *f, const char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vfprintf(f, fmt, ap);
    va_end(ap);
}

void vaul_printer::vfprintf(FILE *out, const char *fmt, va_list ap)
{
    char *mods = "-+ #*0123456789.hlL";

    while(*fmt) {
	const char *cp;
	for(cp = fmt; *fmt && *fmt != '%'; fmt++)
	    ;
	string_out(out, cp, fmt-cp);
	if(*fmt == '%') {	
	    const char *spec = fmt++;
	    while(*fmt && strchr(mods, *fmt))
		fmt++;
	    if(*fmt) {
		fmt++;
		if(fmt[-1] == 'v') {
		    char *vfmt = va_arg(ap, char *);
		    va_list vap = va_arg(ap, va_list);
		    vfprintf(out, vfmt, vap);
		} else
		    format_out(out, spec, fmt-spec, ap);
	    }
	} 
    }
}

void vaul_std_printer::string_out(FILE *f, const char *s, int l)
{
    if(f)
	fwrite(s, sizeof(char), l, f);
}

void vaul_std_printer::format_out(FILE *f, const char *s, int l, va_list &ap)
{
    const char *int_fmts = "cdiouxX";
    const char *float_fmts = "feEgG";
    const char *ptr_fmts = "sp";

    char _s[l+1];
    strncpy(_s, s, l);
    _s[l] = '\0';
    char fmt = s[l-1];

    if(strchr(int_fmts, fmt)) {
	if(f) ::vfprintf(f, _s, ap);
	if(strchr(s, 'l') || strchr(s, 'L'))
	    va_arg(ap, long int);
	else
	    va_arg(ap, int);
    } else if(strchr(float_fmts, fmt)) {
	if(f) ::vfprintf(f, _s, ap);
	if(strchr(s, 'L'))
	    va_arg(ap, long double);
	else
	    va_arg(ap, double);
    } else if(strchr(ptr_fmts, fmt)) {
	if(f) ::vfprintf(f, _s, ap);
	va_arg(ap, void *);
    } else {
	if(f) fprintf(f, "<%s>", _s);
	va_arg(ap, int);
    }
}

void print_to_ostream (tree_base_node *n, ostream &o);

ostream&
operator<< (ostream &o, tree_base_node *n)
{
  if (n)
    print_to_ostream (n, o);
  else
    o << "<null>";
  return o;
}
