;; -*- scheme -*-

(include "freehdl/vaul-chunk.t")

(chunk vaulgens)

(header-add "#include <freehdl/fire.h>"
	    "#include <freehdl/vaul-chunk.h>")

(impl-add "#include \"vaulgens-chunk.h\"")

(defctype VAUL_ObjectClass)

(defgeneric get_base
  (return IIR_Type)
  (methods IIR_Type))

(defgeneric get_class
  (return VAUL_ObjectClass)
  (methods
   IIR_Expression IIR_RecordReference IIR_GenericArrayReference
   IIR_AttrSignalRef IIR_SimpleReference IIR_AccessReference
   IIR_ConstantInterfaceDeclaration IIR_VariableInterfaceDeclaration
   IIR_SignalInterfaceDeclaration IIR_FileInterfaceDeclaration
   IIR_ConstantDeclaration IIR_VariableDeclaration
   IIR_SignalDeclaration IIR_FileDeclaration))

(defgeneric get_mode
  (return IR_Mode)
  (methods
   IIR_Expression IIR_RecordReference IIR_GenericArrayReference
   IIR_AttrSignalRef IIR_SimpleReference IIR_AccessReference
   IIR_InterfaceDeclaration IIR_VariableDeclaration
   IIR_ConstantDeclaration IIR_SignalDeclaration IIR_FileDeclaration))

(defgeneric get_type
  (return IIR_Type)
  (methods
   IIR_RecordReference IIR_ArrayReference IIR_SliceReference
   IIR_SimpleReference IIR_AccessReference))

(defgeneric get_generics
  (return IIR_InterfaceList)
  (methods IIR_ComponentDeclaration IIR_EntityDeclaration
	   IIR_ArchitectureDeclaration IIR_ArchitectureRef
	   IIR_BlockStatement))

(defgeneric get_ports
  (return IIR_InterfaceList)
  (methods IIR_ComponentDeclaration IIR_EntityDeclaration
	   IIR_ArchitectureDeclaration IIR_ArchitectureRef
	   IIR_BlockStatement))

(defgeneric set_generics
  (args (IIR_InterfaceList generics))
  (methods IIR_ComponentDeclaration IIR_EntityDeclaration
	   IIR_BlockStatement))

(defgeneric set_ports
  (args (IIR_InterfaceList ports))
  (methods IIR_ComponentDeclaration IIR_EntityDeclaration
	   IIR_BlockStatement))

(defgeneric get_stats
  (return IIR_ConcurrentStatementList)
  (methods IIR_ComponentDeclaration IIR_EntityDeclaration
	   IIR_ArchitectureDeclaration IIR_ConfigurationDeclaration
	   IIR_BlockStatement))

(defgeneric compute_static_level
  (return IR_StaticLevel)
  (methods IIR_AbstractLiteralExpression
	   IIR_EnumLiteralReference IIR_ArrayLiteralExpression
	   IIR_SimpleReference IIR_RecordReference
	   IIR_Declaration IIR_ConstantDeclaration
	   IIR_ConstantInterfaceDeclaration IIR_FunctionCall
	   IIR_Expression))

(defctype ostream_ref (cname "ostream&"))

(defgeneric print_to_ostream 
  (args (ostream_ref o))
  (methods
   IIR_PosInfo_TextFile IIR_PosInfo_Sheet IIR_Root IIR_TextLiteral
   IIR_IntegerLiteral IIR_FloatingPointLiteral IIR_Declaration
   VAUL_SimpleName VAUL_AttributeName VAUL_SelName VAUL_IftsName
   IIR_Type IIR_Subtype IIR_ArrayType IIR_AccessType IIR_PhysicalType
   IIR_EnumerationLiteral IIR_SubprogramDeclaration IIR_ExplicitRange
   IIR_ArrayRange IIR_TypeList IIR_SimpleReference IIR_SliceReference
   IIR_FunctionCall IIR_AbstractLiteralExpression IIR_PhysicalLiteral
   VAUL_AmbgArrayLitRef IIR_ArrayReference IIR_RecordReference
   IIR_ElementDeclaration IIR_ChoiceByExpression VAUL_ChoiceByName
   IIR_ChoiceByRange VAUL_UnresolvedName IIR_QualifiedExpression
   VAUL_AmbgAggregate VAUL_RangeAssocElem VAUL_NamedAssocElem
   VAUL_AmbgEnumLitRef IIR_Allocator
   IIR_EnumLiteralReference
   ))

